------------------------------------------------------------------------
-- Event:        Delphi Day 2018, Piacenza, June 06 2018               -
--               https://www.delphiday.it/                             -
-- Seminary:     How to write high performance queries in T-SQL        -
-- Demo:         Execution Plan - Index Scan vs Index Seek             -
-- Author:       Sergio Govoni                                         -
-- Notes:        --                                                    -
------------------------------------------------------------------------

USE [AdventureWorks2017];
GO

------------------------------------------------------------------------
-- Index Seek vs Index Scan                                            -
------------------------------------------------------------------------


DBCC FREEPROCCACHE;
GO


EXEC sp_helpindex 'Sales.SalesOrderDetail';
GO


SET STATISTICS IO ON;
GO



SELECT
  h.CustomerID
  ,h.OrderDate
  ,h.SalesOrderNumber
  ,d.ProductID
  ,d.LineTotal
  ,d.UnitPrice
FROM
  Sales.SalesOrderHeader AS h
JOIN
  Sales.SalesOrderDetail AS d 
    ON h.SalesOrderID=d.SalesOrderID;

GO

-- Logical reads 438684 !!

-- SELECT [Page GB] = (438684 * 8 / 1000.0 / 1000.0)

-- Forziamo l'utilizzo di un altro Indice...

SELECT
  h.CustomerID
  ,h.OrderDate
  ,h.SalesOrderNumber
  ,d.ProductID
  ,d.LineTotal
  ,d.UnitPrice
FROM
  Sales.SalesOrderHeader AS h
JOIN
  Sales.SalesOrderDetail AS d WITH (FORCESEEK, INDEX([IX_SalesOrderDetail_SalesOrderID]))
    ON h.SalesOrderID=d.SalesOrderID;
GO